﻿//////////////////////////////////////////////
// Slider.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Enums ------------------------------------

namespace nkWinUi
{
	enum class SLIDER_DIRECTION
	{
		AUTOMATIC = 0,
		LEFT_TO_RIGHT,
		RIGHT_TO_LEFT,
		TOP_TO_BOTTOM,
		BOTTOM_TO_TOP
	} ;
}

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Slider : public Component
	{
		public :
		
			// Constructor, destructor
			Slider (System* system) noexcept ;
			virtual ~Slider () ;

			// Getters
			float getMin () const ;
			float getMax () const ;
			float getCurrent () const ;
			std::function<void (Slider*, float)> getValueChangeCallback () const ;
			SLIDER_DIRECTION getDisplayDirection () const ;

			// Setters
			virtual void setMin (float value) ;
			virtual void setMax (float value) ;
			virtual void setCurrent (float value) ;
			virtual void setValueChangeCallback (std::function<void (Slider*, float)> callback) ;
			virtual void setDisplayDirection (SLIDER_DIRECTION value) ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<Slider> create (System* system = nullptr) ;

		protected :

			// Attributes
			std::function<void (Slider*,  float)> _valueChangeCallback ;

			float _min ;
			float _max ;
			float _current ;

			SLIDER_DIRECTION _displayDirection ;
	} ;
}